-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p1 = Citadels.GetPlayer(1)
    
    if not self.loaded then
      self.active = false
      self.timer = 15
      self.currentWave = 0
    end
    
    self.waveHandler:LinkToTarget("activateAttHandler")
  end
  
  if self.active then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      HandleWave(self)
      self.timer = 5
    end    
  end
end

function HandleWave(self)
	attUnits = self.p1:CheckUnitsCount(6, 1)
  if not attUnits then
    self.active = false
    self.currentWave = 0
    self.waveHandler:TriggerAllTargets()
  end  
end

function OnTrigger(self, source, target)
  if target == "waveActive" then
    self.active = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.active = ar:Read()
    self.timer = ar:Read()
    self.currentWave = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.active)
    ar:Write(self.timer)
    ar:Write(self.currentWave)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("waveActive")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("waveHandler")
end
